<?php

namespace App\Http\Controllers\Canada;
use App\Models\Cms;
use App\Models\Reservations_Model;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Input;
class Index extends Controller {
	
	public function index()
	{
        $data["kiosk_option"]=Cms::table("kiosk_option")->first("*");
        $data["categories"]=Cms::table("kiosk_vendor_categories as a")
            ->leftJoin("kiosk_vendor_images as b","b.vendor_id","a.vendor_id")
            ->groupBy("a.name")
            ->orderBy(\DB::raw("RAND()"),'')    
            ->get("a.name,b.image");
                    
                $data["stores_list"]=Cms::table("kiosk_vendor_units as b")
                    ->leftJoin("kiosk_vendors as a","b.vendor_id","a.id")
                    ->leftJoin("kiosk_vendor_images as c","c.vendor_id","a.id")
                    // ->where('a.id','>',1207)
                    ->orderBy("b.unit_number","asc")
                    ->groupBy("b.vendor_id")
                    ->get("a.id,a.name,a.extra_title,b.unit_number,group_concat(Distinct b.unit_number SEPARATOR ', ') as units");
                    
                $data["stores_unit"]=Cms::table("kiosk_vendors as a")
                    ->leftjoin("kiosk_vendor_units as b","b.vendor_id","a.id")
                    // ->where('a.id','>',1207)
                    ->where('a.name', '<>','""')
                    // ->where('a.id','>',1207)
                    ->orderBy("b.unit_number","asc")
                    // ->orderBy("a.name","asc")
                    ->groupBy("a.id")
                    ->get("a.id,a.name,b.unit_number,group_concat(Distinct b.unit_number SEPARATOR ', ') as units");

                    // dd($data);
		return \View::make('canada.index')->with($data);
	}
}
